﻿var capi = {
    context: $(".v-capi"),
    datatable: null,
    synchLogFilter: null,
    initializeDataTable: function () {
        $(".h-capiModulesTable", this.context).a4datatable({
            title: "Modules",
            ajaxAction: a4.getAction("GetStatisticsCAPIModules", "Home", "Project"),
            columns: [
                { "Title": resources.ProjectId, "Data": "ProjectId", "HideInSelector": true },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.ModuleId, "Data": "Id" },
                { "Title": resources.Module, "Data": "Name", "HideInSelector": true },
                { "Title": resources.Cases, "Data": "Cases", "Type": "numeric" },
                { "Title": resources.Objective, "Data": "Objective", "Type": "numeric" },
                { "Title": resources.Completed, "Data": "Completed", "Type": "numeric" },
                { "Title": resources.Dispatched, "Data": "Dispatched", "Type": "numeric" },
                { "Title": resources.Interviewers, "Data": "Interviewers", "Type": "numeric" },
                { "Title": resources.LastSyncDate, "Data": "LastSyncDate", "Type": "datetime" }
            ],
            stateKey: "CAPIModules",
            contextMenuItems: [
                { "Action": "interviewers", "Label": resources.ViewInterviewerAssignment },
                { "Action": "viewInterviewerSynchHistory", "Label": resources.ViewRepondentSynchLog },
                { "Action": "trackingreport", "Label": resources.TrackingReport },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                
                switch (action) {
                    case "viewInterviewerSynchHistory":
                        modalDialog.showWindow(a4.getAction("ViewModuleSynchLogs", "Home", "Project", { projectId: row.ProjectId, moduleId: row.Id }), "70%", "80%");
                        break
                    case "interviewers":
                        modalDialog.showWindow(a4.getAction("InterviewersAssignment", "Home", "Project", { moduleId: row.Id }), 450, 700);
                        break;
                    case "trackingreport":
                        capi.trackingreport(row.Id);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchModules }
        });

        $(".h-capiInterviewersTable", this.context).a4datatable({
            title: "Interviewers",
            ajaxAction: a4.getAction("GetStatisticsCAPIInterviewers", "Home", "Project"),
            columns: [
                { "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Title": resources.Modules, "Data": "Modules", "Type": "numeric" },
                { "Title": resources.Quotas, "Data": "Quotas", "Type": "numeric" },
                { "Title": resources.Cases, "Data": "Cases", "Type": "numeric" },
                { "Title": resources.Completed, "Data": "Completed", "Type": "numeric" },
                { "Title": resources.LastSyncDate, "Data": "LastSyncDate", "Type": "datetime" }
            ],
            stateKey: "CAPIInterviewers",
            contextMenuItems: [
                { "Action": "viewProjectAssignment", "Label": resources.ViewProjectAssignment },
                { "Action": "viewInterviewerSynchHistory", "Label": resources.ViewRepondentSynchLog },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "viewProjectAssignment":
                        modalDialog.showWindow(a4.getAction("ModulesInterviewers", "Home", "Project", { interviewerId: row.Id }), 450, 700);
                        break;
                    case "viewInterviewerSynchHistory":
                        modalDialog.showWindow(a4.getAction("ViewInterviewerSynchLogs", "Home", "Project", { interviewerId: row.Id }), "70%", "80%");
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchInterviewers }
        });
    },
    bindEvents: function () {

    },
    trackingreport: function (id) {
        a4.callServerMethod(a4.getProjectAction("GetSystemSettings", "Home"), null, function (result) {
            var authString = result.user.ReportingToken;
            var VICUrl = result.settings.VICUrl;

            var slash = "/";
            var loginBaseInfo = "ReportingRedirect.aspx";
            var reportInfo = "?showloading=true&reportType=CapiTracking&projectId=" + id + "&vxapp=";

            if (VICUrl != null && VICUrl.length > 0) {
                if (VICUrl.lastIndexOf(slash) != VICUrl.length - 1)
                    VICUrl += slash;

                VICUrl = VICUrl + loginBaseInfo + reportInfo + authString;

                modalDialog.showWindow(VICUrl, 740, 1000, { "focusFirstField": false });
            }
        });
    }
}

$(document).ready(function () {
    if (capi.context.length > 0) {
        capi.initializeDataTable();
        capi.bindEvents();
    }
});